/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.network;

import com.redpxnda.respawnobelisks.network.handler.S2CHandlers;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class RuneCirclePacket {
    private final boolean kill;
    private final int age;
    private final double x;
    private final double y;
    private final double z;

    public RuneCirclePacket(boolean kill, int age, double x, double y, double z) {
        this.kill = kill;
        this.age = age;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public RuneCirclePacket(FriendlyByteBuf buffer) {
        this.kill = buffer.readBoolean();
        this.age = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.kill);
        buffer.writeInt(this.age);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
    }

    public void handle(Supplier<NetworkManager.PacketContext> supplier) {
        supplier.get().queue(() -> S2CHandlers.setupRuneCircleRenderPacket(this.kill, this.age, this.x, this.y, this.z));
    }
}

